# Authoring

1. [Author Actions](authoring#author-actions)
1. [Make a Submission](authoring#make-submission)
1. [Track your Submission](authoring#track-submission)

When logged in to OJS as an author, you will see two panels: My Assigned and My Authored. If you have never submitted to this journal, both panels will be empty. For more detailed information, see [Learning OJS 3: Authoring](https://docs.pkp.sfu.ca/learning-ojs/en/authoring).

## <a name="author-actions"></a>Author Actions
To the right of your screen, choose New Submission to begin a new submission.


## <a name="make-submission"></a>Make a Submission

*If you're logged in but don't see the editorial interface, you may be viewing the reader-facing website. If that's the case, find your user profile link and click on the Submissions link which appears below it. Each website may be different.*

Making a new submission is an easy-to-follow 5-step process. Follow along with the on-screen instructions to complete the process.

### <a name="start"></a>Start

1. Select an appropriate section for your submission.
1. Read and agree to the Submission Requirements.
1. Add any comments to the editor (optional).
1. Review the Privacy Statement to ensure you agree.

### <a name="upload-submission"></a>Upload Submission

Upload your submission files.

**Upload File**: 

You can upload one or more files with your submission. Select multiple files to upload more than one file at a time or upload each file individually. 

Each file needs to be identified as a particular component type. The type options will vary depending on what has been defined by the journal, but they could include article text, data sets, research results, or images.

Select Save and Continue to move to the next step.

### <a name="enter-metadata"></a>Enter Metadata

Add your submission details, such as title and abstract.

You can add additional authors by using the Add Contributors link.


### <a name="confirmation"></a>Confirmation

Take a moment to confirm the details you've entered. At this point, you can jump back to any of the previous steps to change the details you've entered.

### <a name="next-steps"></a>Next Steps

You've done it! If you want to read more about tracking your submission, read the next section.

## <a name="track-submission"></a>Track your Submission

When your submission is under consideration, you can keep an eye on its status by logging into the website and going to the [Submissions](submissions) page.

Here you'll find you submissions listed with the current stage of the editorial workflow it is in. Click the stage name to interact with that stage.

### <a name="track-submission-discussions"></a>Discussion Panels

In each stage you'll have access to a discussion area. If an editor or editorial assistant needs more information from you, they'll be able to open a discussion. When that happens, you'll be notified by email so that you can respond.

*You won't be able to initiate discussions on most stages, but they'll appear if one has been initiated by the editors.*

### <a name="track-submission-review"></a>Review Stage

During the review stage, you'll see a status update at the top, which will keep you informed as reviewers are recruited, assigned, and submit their reviews.

During the review stage, you may be asked to submit revisions which address any concerns raised. If needed, you'll find a Revisions panel where you can upload new files for the editor.
